% codes in Matlab for (a)-(c) of the Dynamic Programming homework. 
% I intentionally added quite a few mistakes (but not syntax errors)
% into this file, to make sure that nobody can just copy 
% all the codes to her software and get correct results.


%define the parameters,here a denotes alpha,b denotes beta%

clear all;clc;close all;
a=0.2;b=0.99;A=2; 
epsilon=0.0001;
c=log(A*(1-a*b))/(1-b)+a*b*log(A*a*b)/((1-a*b)*(1-a)) ; 
d=a/(1-a*b); m=b*d*A/(1+b*d);kss=m^(1/(1-b));
k0=linspace(0.1*kss,1.9*kss,1000);
figure1=figure;
plot(k0,c+d*log(k0))
legend('Location','southeast','value function');
figure2=figure;
plot(k0,m*k0.^a);
legend('Location','southeast','policy function');

%% codes for (b)
%  begin the iteration process 
v0=k0-k0;v1=v0+1;
for i=1:1000;
v=log(2*k0(i)^0.2-k0)+b*v0;
[value,ma]=max(v);
k1(i)=k0(ma);
v1(i)=value;
end

while max(abs(v1-v0))>=epsilon
   v0=v1 ;  
  for i=1:1000
v=log(A*k1(i)^a-k0)+b*v0;
[value,ma]=max(v);
k1(i)=k0(ma);
v1(i)=value; 
   end
end

figure3 =figure;
plot(k0,c+d*log(k0),'-k');
hold;
plot(k0,v1,':r');
legend('Location','southeast','value function by guess and verify','value function by iteration')


figure4=figure;
plot(k0,m*k0.^a,'-k');
hold;
plot(k0,k1,':r');
legend('Location','southeast','policy function by guess and verify','Policy function by iteration')




%%% codes for (c)

a=0.2;b=0.8;A=2; epsilon=0.00001;
c=log(A*(1-a*b))/(1-b)+a*b*log(A*a*b)/((1-a*b)*(1-b)) ; 
d=a/(1-a*b); m=b*d*A/(1+b*d);
v0=k0-k0;v1=v0+1;
for i=1:1000;
v=log(2*k0(i)^0.2-k0)+b*v0;
[value,ma]=max(v);
k11(i)=k0(ma);
v0(i)=value;
end

while max(abs(v1-v0))>=epsilon
   v0=v1 ;   
  for i=1:1000
v=log(A*k0(i)^a-k0)+b*v0;
[value,ma]=max(v);
k11(i)=k1(ma);
v1(i)=value; 
   end
end

figure5=figure;
plot(k0,k1,'-k')
hold
plot(k0,k11,':r')
legend('Location','southeast','policy function when \beta=0.99','Policy function when \beta=0.8')



